/** @file   ObjectFactory.cpp
 * @brief   Implementation of ObjectFactory class.
 * @version $Revision: 1.11 $
 * @date    $Date: 2006/07/27 20:30:58 $
 * @author  Tomi Lamminsaari
 */

#include "ObjectFactory.h"
#include "CarnivoreAlien.h"
#include "SmallWormAlien.h"
#include "WingedAlien.h"
#include "ProctorAlien.h"
#include "MinigunAlien.h"
#include "PredatorAlien.h"
#include "FlamerAlien.h"
#include "LightballAlien.h"
#include "MediumWormAlien.h"
#include "GuardianTank.h"
#include "Civilian.h"
#include "Car.h"
#include "Tank.h"
#include "SentryGun.h"
#include "Fighter.h"
#include "DecorativeObject.h"
#include "Barrel.h"
#include "Corpse.h"
#include "MachineGun.h"
#include "SpawnParameters.h"
#include "AiController.h"
#include "BadAssAlien.h"
#include "HiddenWormAlien.h"
#include "SlimeAlien.h"
#include "Stargate.h"
#include "Mine.h"
#include "Eric.h"
#include "Simon.h"
#include "Youko.h"
#include "UltimateBadAssAlien.h"
using std::string;
using namespace eng2d;

namespace WeWantWar {

///
/// Constants, datatypes and static methods
/// ============================================================================



GameObject* ObjectFactory::CreateGameObject( SpawnItem* aItem )
{
  if ( aItem == 0 ) {
    return 0;
  }
  
  string mainCategory = aItem->GetLiteral( SpawnItem::EOpeningTag );
  GameObject* object = 0;
  if ( mainCategory == KSpawnCategoryAliens ) {
    object = CreateAlien( aItem );
    
  } else if ( mainCategory == KSpawnCategoryCivilians ) {
    object = CreateCivilian( aItem );
    
  } else if ( mainCategory == KSpawnCategoryCars ) {
    object = CreateCar( aItem );
    
  } else if ( mainCategory == KSpawnCategorySentryGuns ) {
    object = CreateSentryGun( aItem );
    
  } else if ( mainCategory == KSpawnCategoryFighters ) {
    object = CreateFighter( aItem );
    
  } else if ( mainCategory == KSpawnCategoryDecorative ) {
    object = CreateDecorativeObject( aItem );
    
  } else if ( mainCategory == KSpawnCategoryBarrels ) {
    object = CreateBarrelObject( aItem );
    
  } else if ( mainCategory == KSpawnCategoryMachineGuns ) {
    object = new MachineGun;
    
  } else if ( mainCategory == KSpawnCategoryTank ) {
    object = new Tank( Tank::T_TANK1 );
    
  } else if ( mainCategory == KSpawnCategoryCorpse ) {
    object = new Corpse();
    
  } else if ( mainCategory == KSpawnCategoryStargate ) {
    object = CreateStarGate( aItem );
    
  } else if ( mainCategory == KSpawnCategoryMines ) {
    object = new Mine(Mine::ANTI_INFANTRY);
    
  } else if ( mainCategory == KSpawnCategoryNpcCharacter ) {
    object = CreateNpcCharacter( aItem );
    
  }
  if ( object != 0 ) {
    Vec2D position( aItem->iParameters.getFloat(KParamNamePosX),
                    aItem->iParameters.getFloat(KParamNamePosY) );
    Vec2D offset( aItem->iParameters.getFloat(KParamNameOffsetX),
                  aItem->iParameters.getFloat(KParamNameOffsetY) );
    position *= 32;
    position += offset;
    object->position( position );
    object->angle( aItem->iParameters.getInt(KParamNameAngle) );
    object->objectID( aItem->iParameters.getInt(KParamNameIdCode) );
    
    AIController* controller = dynamic_cast<AIController*>( object->getController() );
    if ( controller != 0 ) {
      if ( aItem->iParameters.exists(KParamNameAiRange) == true ) {
        controller->setVisualRange( aItem->iParameters.getFloat(KParamNameAiRange) );
      }
      if ( aItem->iParameters.exists(KParamNameAttackRange) == true ) {
        controller->setAttackDistance( aItem->iParameters.getFloat(KParamNameAttackRange) );
      }
      if ( aItem->iParameters.exists(KParamNameFlags) == true ) {
        int flags = aItem->iParameters.getInt(KParamNameFlags);
        controller->setFlags( flags );
      }
    }
  }
  return object;
}

GameObject* ObjectFactory::CreateAlien( SpawnItem* aItem )
{
  string subType = aItem->iParameters.get( KParamNameSubCategory );
  GameObject* alien = 0;
  if ( subType == "carnivore" ) {
    alien = new CarnivoreAlien();
  } else if ( subType == "smallworm" ) {
    alien = new SmallWormAlien();
  } else if ( subType == "winged" ) {
    alien = new WingedAlien();
  } else if ( subType == "proctor" ) {
    alien = new ProctorAlien();
  } else if ( subType == "minigun" ) {
    alien = new MinigunAlien();
  } else if ( subType == "predator" ) {
    alien = new PredatorAlien();
  } else if ( subType == "flamer" ) {
    alien = new FlamerAlien();
  } else if ( subType == "lightball" ) {
    alien = new LightballAlien();
  } else if ( subType == "mediumworm" ) {
    alien = new MediumWormAlien();
  } else if ( subType == "guardiantank" ) {
    string route = aItem->iParameters.get( KParamNameRouteFile );
    alien = new GuardianTank( route );
  } else if ( subType == "badass" ) {
    alien = new BadAssAlien;
  } else if ( subType == "hiddenworm" ) {
    alien = new HiddenWormAlien;
  } else if ( subType == "slimealien" ) {
    alien = new SlimeAlien;
  } else if ( subType == "ultimate_badass" ) {
    alien = new UltimateBadAssAlien;
  } else {
    alien = 0;
  }
  return alien;
}

GameObject* ObjectFactory::CreateCivilian( SpawnItem* aItem )
{
  int subType = aItem->iParameters.getInt( KParamNameSubCategory );
  string routeFile = aItem->iParameters.get( KParamNameRouteFile );
  
  Civilian::CivType civType = Civilian::TYPE_CIV1;
  switch ( subType ) {
    case (0): civType = Civilian::TYPE_CIV1;  break;
    case (1): civType = Civilian::TYPE_CIV2;  break;
    case (2): civType = Civilian::TYPE_CIV3;  break;
    case (3): civType = Civilian::TYPE_CIV4;  break;
    case (4): civType = Civilian::TYPE_CIV5;  break;
    case (5): civType = Civilian::TYPE_CIV6;  break;
    case (6): civType = Civilian::TYPE_DANCER1; break;
    case (7): civType = Civilian::TYPE_DANCER2; break;
    default: {
      return 0;
    }
  }
  return new Civilian( civType, routeFile );
}

GameObject* ObjectFactory::CreateCar( SpawnItem* aItem )
{
  int subType = aItem->iParameters.getInt( KParamNameSubCategory );
  string routeFile = aItem->iParameters.get( KParamNameRouteFile );
  Car::CarType carType = Car::CAR_TYPE1;
  switch ( subType ) {
    case (0): carType = Car::CAR_TYPE1; break;
    case (1): carType = Car::CAR_TYPE2; break;
    case (2): carType = Car::CAR_TYPE3; break;
    case (3): carType = Car::CAR_TYPE4; break;
    case (4): carType = Car::CAR_TYPE5; break;
    case (5): carType = Car::CAR_TYPE6; break;
    case (6): carType = Car::CAR_TYPE7; break;
    default: {
      return 0;
    }
  }
  return new Car( carType, routeFile );
}

GameObject* ObjectFactory::CreateSentryGun( SpawnItem* aItem )
{
  int subType = aItem->iParameters.getInt( KParamNameSubCategory );
  SentryGun::GunType gunType = SentryGun::T_MACHINEGUN;
  switch ( subType ) {
    case (0): gunType = SentryGun::T_MACHINEGUN;  break;
    case (1): gunType = SentryGun::T_FIREBALL;    break;
    default: {
      return 0;
    }
  }
  return new SentryGun( gunType );
}

GameObject* ObjectFactory::CreateFighter( SpawnItem* aItem )
{
  string subType = aItem->iParameters.get( KParamNameSubCategory );
  Fighter* fighter = new Fighter( subType );
  return fighter;
}

GameObject* ObjectFactory::CreateDecorativeObject( SpawnItem* aItem )
{
  string subType = aItem->iParameters.get( KParamNameSubCategory );
  return new DecorativeObject( subType );
}

GameObject* ObjectFactory::CreateBarrelObject( SpawnItem* aItem )
{
  string subType = aItem->iParameters.get( KParamNameSubCategory );
  GameObject* object = 0;
  if ( subType == "0" ) {
    return new Barrel( Barrel::EOil );
  }
  return 0;
}

GameObject* ObjectFactory::CreateNpcCharacter( SpawnItem* aItem )
{
  string subType = aItem->iParameters.get( KParamNameSubCategory );
  GameObject* object = 0;
  if ( subType == "eric" ) {
    return new Eric;
  } else if ( subType == "simon" ) {
    return new Simon;
  } else if ( subType == "youko" ) {
    return new Youko;
  }
  return 0;
}

GameObject* ObjectFactory::CreateStarGate( SpawnItem* aItem )
{
  StarGate* gate = new StarGate();
  if ( aItem->iParameters.exists( KParamNameDelay ) == true ) {
    gate->setSpawnDelay( aItem->iParameters.getInt(KParamNameDelay) );
  }
  return gate;
}

};  // end of namespace
